/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Explosion;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.Flag;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class RoboBomb
extends EntityLiving {
    public RoboBomb(World w) {
        super(w);
        this.maxrenderdist = 64;
        this.height = 0.75f;
        this.width = 0.75f;
        this.uniquename = "OreSpawn:RoboBomb";
        this.moveSpeed = 0.2f;
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(1.0f);
        this.searchDistance = 16.0f;
        this.attackRange = 2.0f;
        this.movefrequency = 25;
        this.setExperience(19);
        this.canSwim = false;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        int which = this.world.rand.nextInt(8);
        if (which == 0) {
            return "OreSpawn:robot_hurt1";
        }
        if (which == 1) {
            return "OreSpawn:robot_hurt2";
        }
        if (which == 2) {
            return "OreSpawn:robot_hurt3";
        }
        if (which == 3) {
            return "OreSpawn:robot_hurt4";
        }
        if (which == 4) {
            return "OreSpawn:robot_hurt5";
        }
        if (which == 5) {
            return "OreSpawn:robot_hurt6";
        }
        if (which == 6) {
            return "OreSpawn:robot_hurt7";
        }
        return "OreSpawn:robot_hurt8";
    }

    public String getDeathSound() {
        int which = this.world.rand.nextInt(6);
        if (which == 0) {
            return "OreSpawn:robot_death1";
        }
        if (which == 1) {
            return "OreSpawn:robot_death2";
        }
        if (which == 2) {
            return "OreSpawn:robot_death3";
        }
        if (which == 3) {
            return "OreSpawn:robot_death4";
        }
        if (which == 4) {
            return "OreSpawn:robot_death5";
        }
        return "OreSpawn:robot_death6";
    }

    public void doDeathDrops() {
        Utils.doDropRand((World)this.world, (int)0, (int)Items.instability.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyrobobomb.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public void update(float deltaT) {
        if (this.isSwarming()) {
            this.moveSpeed = 0.36f;
        }
        if (!this.world.isServer && this.getAttacking()) {
            if (this.world.rand.nextInt(10) == 1) {
                Utils.spawnParticles((World)this.world, (String)"DangerZone:ParticleFire", (int)5, (int)this.dimension, (double)this.posx, (double)(this.posy + 0.75), (double)this.posz, (boolean)false);
            }
            if (this.world.rand.nextInt(10) == 1) {
                Utils.spawnParticles((World)this.world, (String)"DangerZone:ParticleSmoke", (int)5, (int)this.dimension, (double)this.posx, (double)(this.posy + 0.75), (double)this.posz, (boolean)false);
            }
        }
        super.update(deltaT);
    }

    public void doAttack(Entity victim) {
        Explosion.boom((Entity)this, (World)this.world, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz, (int)(5 + this.world.rand.nextInt(6)), (boolean)true);
        this.deadflag = true;
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Flag && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/RoboBombtexture.png");
        }
        return this.texture;
    }
}

